/*
	Name:			XenoN Core Image Component Header
	Version:		1.0
	Update:			2011-02-24
	Copyright:		Copyright  2007-2011 XenoN Core by PsichiX. All rights reserved.
	Author:			PsichiX
	Website:		http://www.xenon.psichix.com
	Description:	XenoN Core Framework Image Component Header
*/

/*
	== EN ==
	This file is part of Xenon Core Framework.
	You may distribute it further, but you can not modify it.
	Please do not use in modified form.
	The principles of XenoN Core License available in the file LICENSE_CORE_EN.TXT or visit: http://www.xenon.psichix.com.

	== PL ==
	Ten plik jest czescia XenoN Core Framework.
	Mozesz go rozpowszechniac dalej, jednak nie mozesz go modyfikowac.
	Nalezy uzytkowac w nie zmodyfikowanej formie.
	Nalezy przestrzegac zasad Licencji XenoN Core dostepnej w pliku LICENSE_CORE_PL.TXT oraz na stronie: http://www.xenon.psichix.com.
*/

#ifndef XE_COMPONENT_IMAGE_H
#define XE_COMPONENT_IMAGE_H

#include "GdiPlus.h"
#pragma comment(lib,"GdiPlus.lib")

using namespace Gdiplus;

#include "../System/XenonCoreFramework.h"

namespace XeCore
{
//! Przestrzen nazw komponentow
namespace Com
{

class C_IMAGE;

#ifdef XE_COMPILE_PHOTON

int GetEncoderClsid(const WCHAR* format, CLSID* pClsid);

#ifdef XE_CANIMP

int GetEncoderClsid(const WCHAR* format, CLSID* pClsid)
{
   UINT  num = 0;
   UINT  size = 0;

   ImageCodecInfo* pImageCodecInfo = NULL;

   GetImageEncodersSize(&num, &size);
   if(size == 0)
      return -1;

   pImageCodecInfo = (ImageCodecInfo*)(malloc(size));
   if(pImageCodecInfo == NULL)
      return -1;

   GetImageEncoders(num, size, pImageCodecInfo);

   for(UINT j = 0; j < num; ++j)
   {
      if( wcscmp(pImageCodecInfo[j].MimeType, format) == 0 )
      {
         *pClsid = pImageCodecInfo[j].Clsid;
         free(pImageCodecInfo);
         return j;
      }    
   }

   free(pImageCodecInfo);
   return -1;
}

#endif /* XE_CANIMP */

//! Klasa obrazu.
class C_IMAGE
{
public:
	/*! Laduje teksture z pliku obrazu.
	\param texture Element tekstury.
	\param fname Sciezka do pliku.
	\return true jesli operacja powiodla sie.
	*/
	static bool LoadTexture( XE_ELM_TEXTURE texture, char* fname );
	/*! Laduje teksture z pliku EXE lub DLL.
	\param texture Element tekstury.
	\param fname Sciezka do pliku. Wartosc 0 jesli ma zaladowac ikone bierzacej aplikacji.
	\param index Indeks ikony aplikacji.
	\param width Preferowana szerokosc ikony.
	\param height Preferowana wysokosc ikony.
	\return true jesli operacja powiodla sie.
	*/
	static bool LoadTextureFromAppIcon( XE_ELM_TEXTURE texture, char* fname,int index, int width, int height );
	/*! Zapisuje teksture do pliku obrazu.
	\param texture Element tekstury.
	\param fname Sciezka do pliku.
	\param format Format (rozszerzenie) pliku.
	\return true jesli operacja powiodla sie.
	*/
	static bool SaveTexture( XE_ELM_TEXTURE texture, char* fname, char* format );
	/*! Laduje sprajta z plikow obrazow.
	\param sprite Referencja na docelowy sprajt.
	\param filenames Sciezki do plikow, rozdzielane znakiem ";".
	\param minfilter Filtr pomniejszajacy.
	\param magfilter Filtr powiekszajacy.
	\param xoff Przesuniecie srodka w osi X.
	\param yoff Przesuniecie srodka w osi Y.
	\param bw Szerokosc prostokata kolizji.
	\param bh Wysokosc prostokata kolizji.
	\param bxoff Przesuniecie srodka w osi X prostokata kolizji.
	\param byoff Przesuniecie srodka w osi Y prostokata kolizji.
	\return true jesli operacja powiodla sie.
	*/
	static bool PrepareSprite( XE_SPRITE& sprite, char* filenames, XE_ESTATE minfilter=XE_TEXTURE_PARAM_NEAREST, XE_ESTATE magfilter=XE_TEXTURE_PARAM_NEAREST, int xoff=0,int yoff=0,int bw=-1,int bh=-1,int bxoff=0,int byoff=0 );
	/*! Laduje sprajta z pliku EXE lub DLL.
	\param sprite Referencja na docelowy sprajt.
	\param fname Sciezka do pliku. Wartosc 0 jesli ma zaladowac ikone bierzacej aplikacji.
	\param index Indeks ikony aplikacji.
	\param width Preferowana szerokosc ikony.
	\param height Preferowana wysokosc ikony.
	\param minfilter Filtr pomniejszajacy.
	\param magfilter Filtr powiekszajacy.
	\param xoff Przesuniecie srodka w osi X.
	\param yoff Przesuniecie srodka w osi Y.
	\param bw Szerokosc prostokata kolizji.
	\param bh Wysokosc prostokata kolizji.
	\param bxoff Przesuniecie srodka w osi X prostokata kolizji.
	\param byoff Przesuniecie srodka w osi Y prostokata kolizji.
	\return true jesli operacja powiodla sie.
	*/
	static bool PrepareSpriteFromAppIcon( XE_SPRITE& sprite, char* fname, int index, int width, int height, XE_ESTATE minfilter=XE_TEXTURE_PARAM_NEAREST, XE_ESTATE magfilter=XE_TEXTURE_PARAM_NEAREST, int xoff=0,int yoff=0,int bw=-1,int bh=-1,int bxoff=0,int byoff=0 );
	/*! Przygotowuje czcionke z plikow map i obrazow.
	\param font Referencja na docelowa czcionke.
	\param texfname Nazwa pliku z tekstura czcionki.
	\param mapfname Nazwa pliku z mapa czcionki.
	\param newline Znak nowej linii.
	\param minfilter Filtr pomniejszajacy.
	\param magfilter Filtr powiekszajacy.
	\return true jesli operacja powiodla sie.
	*/
	static bool PrepareFont( XE_FONT& font, char* texfname, char* mapfname=0, int newline='\n', XE_ESTATE minfilter=XE_TEXTURE_PARAM_NEAREST, XE_ESTATE magfilter=XE_TEXTURE_PARAM_NEAREST );
};

#ifdef XE_CANIMP

bool C_IMAGE::LoadTexture( XE_ELM_TEXTURE texture, char* fname )
{
	XE_STRING str(fname);
	wchar_t name[1024]={0};
	str.GetUnicode(name,1024);
	bool status=false;
	ULONG_PTR gptoken=0;
	Gdiplus::GdiplusStartupInput gpsi;
	Gdiplus::GdiplusStartup(&gptoken,&gpsi,NULL);
	Bitmap* image=new Bitmap(name);
	BitmapData data;
	Rect rect(0,0,(int)image->GetWidth(),(int)image->GetHeight());
	if(!image->LockBits(&rect,ImageLockModeWrite|ImageLockModeRead,PixelFormat32bppARGB,&data))
	{
		unsigned char* pos=(unsigned char*)data.Scan0;
		unsigned char col[4]={0};
		for(unsigned int p=0;p<image->GetWidth()*image->GetHeight();p++)
		{
			col[0]=pos[2];
			col[1]=pos[1];
			col[2]=pos[0];
			col[3]=pos[3];
			*(unsigned int*)pos=*(unsigned int*)col;
			pos+=4;
		}
		status=Photon::XeTextureLoadRGBAFromMemory(texture,data.Scan0,(int)image->GetWidth(),(int)image->GetHeight());
		image->UnlockBits(&data);
	}
	delete image;
	Gdiplus::GdiplusShutdown(gptoken);
	str.Clear();
	return(status);
}

bool C_IMAGE::LoadTextureFromAppIcon( XE_ELM_TEXTURE texture, char* fname, int index, int width, int height )
{
	HICON icon=0;
	unsigned int st=0;
	if(!fname)
	{
		fname=new char[1024];
		GetModuleFileName(0,fname,1024);
		if(!PrivateExtractIcons(fname,index,width,height,&icon,&st,1,0))
		{
			delete[] fname;
			return(false);
		}
		delete[] fname;
		fname=0;
	}
	else
	if(!PrivateExtractIcons(fname,index,width,height,&icon,&st,1,0))
		return(false);
	if(st==0xFFFFFFFF)
		return(false);
	bool status=false;
	ULONG_PTR gptoken=0;
	Gdiplus::GdiplusStartupInput gpsi;
	Gdiplus::GdiplusStartup(&gptoken,&gpsi,NULL);
	Bitmap* image=new Bitmap(icon);
	BitmapData data;
	Rect rect(0,0,(int)image->GetWidth(),(int)image->GetHeight());
	if(!image->LockBits(&rect,ImageLockModeWrite|ImageLockModeRead,PixelFormat32bppARGB,&data))
	{
		unsigned char* pos=(unsigned char*)data.Scan0;
		unsigned char col[4]={0};
		for(unsigned int p=0;p<image->GetWidth()*image->GetHeight();p++)
		{
			col[0]=pos[2];
			col[1]=pos[1];
			col[2]=pos[0];
			col[3]=pos[3];
			*(unsigned int*)pos=*(unsigned int*)col;
			pos+=4;
		}
		status=Photon::XeTextureLoadRGBAFromMemory(texture,data.Scan0,(int)image->GetWidth(),(int)image->GetHeight());
		image->UnlockBits(&data);
	}
	delete image;
	Gdiplus::GdiplusShutdown(gptoken);
	DestroyIcon(icon);
	return(status);
}

bool C_IMAGE::SaveTexture( XE_ELM_TEXTURE texture, char* fname, char* format )
{
	XE_STRING str(fname);
	wchar_t name[1024]={0};
	str.GetUnicode(name,1024);
	wchar_t fformat[1024]={0};
	str.Format("image/%s",format);
	str.GetUnicode(fformat,1024);
	bool status=false;
	void* pixels=Photon::XeTextureLock(texture);
	if(!pixels)return(false);
	int w=Photon::XeTextureGetReal(texture,XE_TEXTURE_WIDTH);
	int h=Photon::XeTextureGetReal(texture,XE_TEXTURE_HEIGHT);
	if(w<=0||h<=0)
	{
		Photon::XeTextureUnlock(texture,false);
		return(false);
	}
	BYTE* bytes=new BYTE[w*h*4];
	ULONG_PTR gptoken=0;
	Gdiplus::GdiplusStartupInput gpsi;
	Gdiplus::GdiplusStartup(&gptoken,&gpsi,NULL);
	Bitmap* image=new Bitmap(w,h,w*4,PixelFormat32bppARGB,bytes);
	BitmapData data;
	Rect rect(0,0,(int)image->GetWidth(),(int)image->GetHeight());
	if(!image->LockBits(&rect,ImageLockModeWrite|ImageLockModeRead,PixelFormat32bppARGB,&data))
	{
		unsigned char* pos=(unsigned char*)data.Scan0;
		unsigned char* pix=(unsigned char*)pixels;
		for(unsigned int p=0;p<image->GetWidth()*image->GetHeight();p++)
		{
			pos[0]=pix[2];
			pos[1]=pix[1];
			pos[2]=pix[0];
			pos[3]=pix[3];
			pos+=4;
			pix+=4;
		}
		image->UnlockBits(&data);
		CLSID Clsid;
		GetEncoderClsid(fformat,&Clsid);
		status=image->Save(name,&Clsid,0)==0?true:false;
	}
	Photon::XeTextureUnlock(texture,false);
	delete[] bytes;
	delete image;
	Gdiplus::GdiplusShutdown(gptoken);
	str.Clear();
	return(status);
}

bool C_IMAGE::PrepareSprite( XE_SPRITE& sprite, char* filenames, XE_ESTATE minfilter, XE_ESTATE magfilter, int xoff, int yoff, int bw, int bh, int bxoff, int byoff )
{
	XE_ELM_TEXTURE temp;
	char* next;
	char* fname=strtok_s(filenames,";",&next);
	while(fname!=NULL)
	{
		Photon::XeTextureCreate(&temp);
		if(!temp.IsEmpty())
		if(LoadTexture(temp,fname))
		{
			Photon::XeTextureActivate(temp);
			Photon::XeTextureParameter(XE_TEXTURE_PARAM_MIN_FILTER,(float)minfilter);
			Photon::XeTextureParameter(XE_TEXTURE_PARAM_MAG_FILTER,(float)magfilter);
			Photon::XeTextureUnactivate();
			sprite.AddTexture(temp);
			sprite.Width=max(sprite.Width,(int)*(unsigned int*)Photon::XeTextureGet(temp,XE_TEXTURE_WIDTH));
			sprite.Height=max(sprite.Height,(int)*(unsigned int*)Photon::XeTextureGet(temp,XE_TEXTURE_HEIGHT));
		}
		fname=strtok_s(NULL,";",&next);
	}
	sprite.SetCurrent(0);
	sprite.Xoffset=xoff;
	sprite.Yoffset=yoff;
	sprite.BboxWidth=bw;
	sprite.BboxHeight=bh;
	sprite.BboxXoffset=bxoff;
	sprite.BboxYoffset=byoff;
	if(sprite.BboxWidth<0){sprite.BboxWidth=sprite.Width;sprite.BboxXoffset=sprite.Xoffset;}
	if(sprite.BboxHeight<0){sprite.BboxHeight=sprite.Height;sprite.BboxYoffset=sprite.Yoffset;}
	sprite.RectUpdate();
	sprite.CoordsUpdate();
	sprite.ForcePrepared(true);
	return(true);
}

bool C_IMAGE::PrepareSpriteFromAppIcon( XE_SPRITE& sprite, char* fname, int index, int width, int height, XE_ESTATE minfilter, XE_ESTATE magfilter, int xoff, int yoff, int bw, int bh, int bxoff, int byoff )
{
	XE_ELM_TEXTURE temp;
	Photon::XeTextureCreate(&temp);
	if(!temp.IsEmpty())
	if(LoadTextureFromAppIcon(temp,fname,index,width,height))
	{
		Photon::XeTextureActivate(temp);
		Photon::XeTextureParameter(XE_TEXTURE_PARAM_MIN_FILTER,(float)minfilter);
		Photon::XeTextureParameter(XE_TEXTURE_PARAM_MAG_FILTER,(float)magfilter);
		Photon::XeTextureUnactivate();
		sprite.AddTexture(temp);
		sprite.Width=max(sprite.Width,(int)*(unsigned int*)Photon::XeTextureGet(temp,XE_TEXTURE_WIDTH));
		sprite.Height=max(sprite.Height,(int)*(unsigned int*)Photon::XeTextureGet(temp,XE_TEXTURE_HEIGHT));
	}
	sprite.SetCurrent(0);
	sprite.Xoffset=xoff;
	sprite.Yoffset=yoff;
	sprite.BboxWidth=bw;
	sprite.BboxHeight=bh;
	sprite.BboxXoffset=bxoff;
	sprite.BboxYoffset=byoff;
	if(sprite.BboxWidth<0){sprite.BboxWidth=sprite.Width;sprite.BboxXoffset=sprite.Xoffset;}
	if(sprite.BboxHeight<0){sprite.BboxHeight=sprite.Height;sprite.BboxYoffset=sprite.Yoffset;}
	sprite.RectUpdate();
	sprite.CoordsUpdate();
	sprite.ForcePrepared(true);
	return(true);
}

bool C_IMAGE::PrepareFont( XE_FONT& font, char* texfname, char* mapfname, int newline, XE_ESTATE minfilter, XE_ESTATE magfilter )
{
	if(!texfname)return(false);
	XeSetState(XE_RENDER_TEXT_NEWLINE,newline);
	Photon::XeTextureCreate(&font.Texture);
	if(font.Texture.IsEmpty())return(false);
	if(LoadTexture(font.Texture,texfname))
	{
		Photon::XeTextureParameter(XE_TEXTURE_PARAM_MIN_FILTER,(float)minfilter);
		Photon::XeTextureParameter(XE_TEXTURE_PARAM_MAG_FILTER,(float)magfilter);
		Photon::XeTextureUnactivate();
		if(mapfname)
		{
			font.Map=new XE_FONTMAP;
			if(!font.Map)
			{
				Photon::XeTextureDestroy(font.Texture);
				return(false);
			}
			if(!font.Map->Compile(mapfname))
			{
				delete font.Map;
				font.Map=0;
				Photon::XeTextureDestroy(font.Texture);
				return(false);
			}
		}
		if(Photon::XeGenerateFont(&font.Dlist,font.Map))
		{
			font.ForcePrepared(true);
			return(true);
		}
		return(false);
	}
	return(false);
}

#endif /* XE_CANIMP */

#endif /* XE_COMPILE_PHOTON */

} /* namespace: Com */
} /* namespace: XeCore */

#endif /* XE_COMPONENT_IMAGE_H */
